vec3 water_fog(vec3 position0, vec3 position1, vec3 vector, vec3 direction, vec3 sun_direction, vec3 moon_direction, vec3 noise, float lightmap, bool atmosphere, inout vec3 transmittance){
    water_settings ws = water_s();

    float VdotL = dot(vector, direction);
    float phase0 = phase_rayleigh(VdotL);
    float phase1 = hg_phase(VdotL, 0.5);

    vec3 up_direction = vec3(0.0, 1.0, 0.0);

    vec3 ray_increment = (position1 - position0) / float(ws.steps);
    vec3 ray_position = position0 + ray_increment * noise.x; ray_position += cameraPosition;

    vec3 shadow_position0 = world_to_shadowspace(position0);
    vec3 shadow_position1 = world_to_shadowspace(position1);

    vec3 shadow_increment = (shadow_position1 - shadow_position0) / float(ws.steps);
    vec3 shadow_position = shadow_position0 + shadow_increment * noise.x;

    float ray_length = distance(position0, position1) / ws.steps;

    vec3 direct_scattering = vec3(0.0), indirect_scattering = vec3(0.0);

    vec3 density = ws.attenuation_coefficient * ws.density * ray_length;
    vec3 step_transmittance = exp(-density);
    vec3 step_transmittance_fraction = 1.0 - step_transmittance;

    #ifdef WATER_FOG
        for(int i = 0; i < ws.steps; ++i, ray_position += ray_increment, shadow_position += shadow_increment){
            vec3 sample_transmittance = transmittance * step_transmittance_fraction;
            vec3 shadow = volumetric_shadow(shadow_position, ray_position - cameraPosition, true);

            direct_scattering += sample_transmittance * shadow;
            indirect_scattering += sample_transmittance;

            transmittance *= step_transmittance;
        }

        #if defined VOLUMETRIC_CLOUD && defined CLOUDS_SHADOW
            const float rain_brightness = 1.0;
        #else
            const float rain_brightness = mix(1.0, 0.0, wetness);
        #endif

        vec3 sunlight = atmospheric_transmittance(sun_direction, moon_direction) * rain_brightness;
        vec3 skylight = texture2(colortex1, project_sphere(up_direction)).xyz;

        vec3 scattering = direct_scattering * sunlight * phase1;
             scattering += indirect_scattering * skylight * pow4(eyeBrightnessSmooth.y / 254.0);
             scattering *= ws.scattering_coefficient;
			 
		if(atmosphere){
			vec3 light = sunlight * phase1;
                 light += skylight * pow4(eyeBrightnessSmooth.y / 254.0);
			 
			//scattering += light * ws.scattering_coefficient * transmittance;
			//transmittance = vec3(0.0);
		}

        return max0(scattering);
    #else
        return exp(-ws.attenuation_coefficient * ws.density * distance(position1, position0));
    #endif
}